uniform sampler2D s_texture0; // this should hold the texture rendered by the horizontal blur pass
varying vec2 v_texCoord;

const float blurSize = 1.0/64.0;

void main(void)
{
  vec4 sum = vec4(0.0);
  
  // blur in y (vertical)

  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - 7.0*blurSize)) * 0.02;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - 6.0*blurSize)) * 0.032;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - 5.0*blurSize)) * 0.046;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - 4.0*blurSize)) * 0.06;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - 3.0*blurSize)) * 0.075;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - 2.0*blurSize)) * 0.088;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y - blurSize)) * 0.097;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y)) * 0.1;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + blurSize)) * 0.097;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + 2.0*blurSize)) * 0.088;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + 3.0*blurSize)) * 0.075;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + 4.0*blurSize)) * 0.06;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + 5.0*blurSize)) * 0.046;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + 6.0*blurSize)) * 0.032;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y + 7.0*blurSize)) * 0.02;

//  gl_FragColor = vec4(1,0,1,1);
  gl_FragColor = sum;
}